--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A structure that contains region information.
--- @class tes3region : tes3baseObject
--- @field name string The region's name. It must be a string less than 32 characters long.
--- @field sleepCreature tes3leveledCreature *Read-only*. The region's leveled creature that can be spawned while the player is sleeping.
--- @field sounds tes3regionSound[] *Read-only*. Array-style table for the different region sounds. Each object in the table is a [`tes3regionSound`](https://mwse.github.io/MWSE/types/tes3regionSound/).
--- @field weather tes3weather|tes3weatherAsh|tes3weatherBlight|tes3weatherBlizzard|tes3weatherClear|tes3weatherCloudy|tes3weatherFoggy|tes3weatherOvercast|tes3weatherRain|tes3weatherSnow|tes3weatherThunder The region's current weather.
--- @field weatherChanceAsh integer The chance the Ash weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceBlight integer The chance the Blight weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceBlizzard integer The chance the Blizzard weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceClear integer The chance the Clear weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceCloudy integer The chance the Cloudy weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceFoggy integer The chance the Foggy weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceOvercast integer The chance the Overcast weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceRain integer The chance the Rain weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChances number[] *Read-only*. Array-style table for the different weather chances. Each object in the table is a number, between 1 - 100. The index of the table is the weather type.
--- @field weatherChanceSnow integer The chance the Snow weather-type will be used. Must be an integer between `0` and `100`.
--- @field weatherChanceThunder integer The chance the Thunder weather-type will be used. Must be an integer between `0` and `100`.
tes3region = {}

--- Changes the current weather for the region to the provided weather-type parameter.
--- @param weatherId tes3.weather Maps to values in the [`tes3.weather`](https://mwse.github.io/MWSE/references/weather-types/) table.
function tes3region:changeWeather(weatherId) end

--- Changes the weather to a random weather type.
function tes3region:randomizeWeather() end

